# coding: iso-8859-1



class Project_XP < Project

  def decompiler(toutes)

    if $rmxp == true
      type = "RMXP"
    end


    # Liste les fichiers RMXP du projet
    begin
      liste = lister_rm_a_traiter(toutes, type)
    rescue DMKW_Vide_File, DMKW_Vide_File_Mod_Ajout => e
      # Le dossier est vide, ou ne contient aucun fichier modifi ou ajout
      Affichage::info(e.message)
      raise(DMKW_Cancel.new)
    end




    # S'il y a bien des maps ou lments de BD  traiter, on les traite
    decompiler_liste(liste)

    return liste

  end


  

  
  # Liste toutes les maps RM, et affiche un message correspondant  ce qui
  # est trouv
  def lister_rm_a_traiter(toutes, type)
    lister_a_traiter(toutes, type, :lister_rm, :lister_rm_modif,
      :lister_rm_ajout, @dossier_rm)
  end

  def lister_dmk_a_traiter(toutes, type)
    lister_a_traiter(toutes, type, :lister_dmk, :lister_dmk_modif,
      :lister_dmk_ajout, @dossier_dmk)
  end
  

  def lister_a_traiter(toutes, type, meth, meth_modif, meth_ajout, dossier_avant)
    if toutes == true
      traiter = send(meth, dossier_avant)
      Affichage::info("#2 %d fichiers %s trouvs", traiter.size, type)
      if traiter.size == 0
        # WARNING : le dossier ne contient aucune map
        raise(DMKW_Vide_File.new(type, dossier_avant))
      end
      return traiter
    end


    # Si on ne prend que les maps modifies et / ou ajoutes

    # Slection des fichiers modifis et ajouts
    liste_modif = send(meth_modif, dossier_avant)
    liste_ajout = send(meth_ajout, @dossier_rm, @dossier_dmk)
    Affichage::info("#1 %d fichiers %s modifis et %d ajouts trouvs", liste_modif.size, liste_ajout.size)

    traiter = liste_modif + liste_ajout

    #p liste

    if traiter.size == 0
      # WARNING : il n'y a aucune map modifie ou ajoute
      raise(DMKW_Vide_File_Mod_Ajout.new(type, dossier_avant))
    end


    return traiter

  end







  # Transforme un fichier RMXP en fichier DMK
  # Retransforme ensuite le fichier DMK en fichier RMXP, et compare les deux pour
  # vrifier qu'il n'y a aucune diffrence
  def decompiler_rm_test(path)

    name = path.basename

    #return nil if name[0..3] != "MapI"

    printl "Extraction test : "+name+" "

    # On rcupre la version modifie du fichier RM (par exemple
    # My_Common_Events au lieu de l'array utilis par RMXP)
    file_rm_mod = charger_rm(path)
    file_rm_mod.name = name
    #puts ""
    file_rmxp = file_rm_mod.to_rmxp

    # Affectation de son numro  la map
    #numero = ((/(\d+)\.rxdata$/.match(path))[1]).to_i
    #map_dmk = map_rmxp.to_dmk(numero)

    file_dmk = file_rm_mod.to_dmk

    # Vrification de compatibilit
    file_rmxp_2 = file_dmk.to_rmxp


    begin
      #if file_rmxp.is_a?(Array)
      #  p file_rmxp[0..2]
      #  p file_rmxp_2[0..2]
      #end
      #p file_rmxp.class, file_rmxp_2.class
      #p file_rmxp, file_rmxp_2
      raise(DMKW_DMK_Diff.new("Decompilation Test : class")) if file_rmxp.class != file_rmxp_2.class
      if file_rmxp.is_a?(Array) == false and file_rmxp.is_a?(Hash) == false
        file_rmxp.comparer(file_rmxp_2)
      else
        
        if file_rmxp.is_a?(Array)
          # Elments de la BD
          #pa file_rmxp[1].class, file_rmxp_2[1].class
          if file_rmxp.size != file_rmxp_2.size
            raise(DMKW_DMK_Diff.new("Decompilation Test: DB array size"))
          end
          
          #for i in 1...file_rmxp.size
          #  file_rmxp[i].comparer(file_rmxp_2[i])
          #end

        else
          if file_rmxp.size != file_rmxp_2.size
            raise(DMKW_DMK_Diff.new("Decompilation Test: hash size"))
          end
          # MapInfos
          list = file_rmxp.keys
          for key in list
            file_rmxp[key].comparer(file_rmxp_2[key])
          end
        end
      end
      puts "OK"
    rescue DMKW_DMK_Diff => e
      puts "BAD !!"
      raise(DMKW_DMK_Incompatible.new(path, e.message.just_lines(4)))
    end


    return file_dmk
  end







end